/******************************************************************************
 * 
 *   This file is part of SC1 - Studer Communication driver 1, by Sven Ruin
 *   and Anders Andersson.
 *   
 ******************************************************************************/

#ifndef _FPM_UFPTSC1_H
#define _FPM_UFPTSC1_H

// Sven's code - begin
#define SIO_KYBD_MODE_RAW     1
#define SIO_KYBD_MODE_SET       0x1011
// Sven's code - end

// -------------------------------------------------------------------
// includes go here.
// -------------------------------------------------------------------

// Sven's code - begin
#include <string>
// Sven's code - end

#include "standard.h"
#include "FPM_Variable.h"
#include "FPM_Starter.h"
#include "FPM_DriverProperties.h"


using namespace std;

using namespace SmartServer::FPM_LIB_VERSION;
using namespace FPM;

//-------------------------------------------------------------------
// ==> FPM module unique name
//-------------------------------------------------------------------
#define FPM_MODULE_NAME  "#9FFD030000000000[5].UFPTSC1"

namespace _9FFD030000000000_5__UFPTSC1_DRV
{
// Sven's code - begin
typedef int HANDLE;
// Sven's code - end

// -------------------------------------------------------------------
//   class:  CUFPTSC1
// -------------------------------------------------------------------
class CUFPTSC1 : public CFPM_App, public TSingleton<CUFPTSC1>
{
  // -----------------------------------------------------------------
  //  Constructor / Destructor
  // -----------------------------------------------------------------
  protected:
    CUFPTSC1::CUFPTSC1();
    ~CUFPTSC1();


  // -----------------------------------------------------------------
  //   Implements the user functionality
  // -----------------------------------------------------------------
  public:
    // Initialization and Cleanup
    virtual void Initialize();
    virtual void Shutdown();

    // User implemented methods
    virtual void Work();
    virtual void OnTimer();
    //void OnMyTimer();

  // -----------------------------------------------------------------
  //   Utility Methods
  // -----------------------------------------------------------------
  public:

  // -----------------------------------------------------------------
  //   Internals
  // -----------------------------------------------------------------
  // -----------------------------------------------------------------
  //   Module Startup/Shutdown Methods
  // -----------------------------------------------------------------
  public:
    STATUS StartModule(const char* pszModuleName);
    STATUS StopModule(const char* pszModuleName);
  // -----------------------------------------------------------------
  //   Mandatory Application Members
  // -----------------------------------------------------------------
  private:
    friend class FPM::TSingleton<CUFPTSC1>;
    static CUFPTSC1 *m_pSingleton;

    // Sven's code - begin
    CFPM_Timer m_oTimer1;
    //CFPM_Timer m_oTimer2;
    int BytesReadyForRead( HANDLE handle ) const;
	void RxbufClean( HANDLE handle) const;
    // Sven's code - end
};


#define START_TIMER(timerVar, mode, timeoutMillis, funcName)  \
  timerVar.Start<CUFPTSC1>( mode, timeoutMillis, this, &CUFPTSC1::funcName );
/*
#define START_TIMER2(timerVar, mode, timeoutMillis, instance, className, funcName)  \
  timerVar.Start<className>( mode, timeoutMillis, instance, &className::funcName );
*/

template <typename T>
Variable<T>* DeclareVariable(const char* pszCppType, const char* pszName, const enum FPM_DpDirection eDirection, 
    const char* pszFptKey, const char* pszFbUrl, const char* pszDpRefType/*, int nPollrate = 500*/)
{
  Variable<T>* p = new Variable<T>( ToILonFormat( pszCppType ).c_str(), pszName, eDirection );
  (*CUFPTSC1::GetSingleton()->m_pDeclaredVariables).insert( NameToVariableMap_t::value_type( pszName, p ) );
  if (NULL != pszFptKey) {
    p->SetDpProperty( 0x8000000, pszFptKey );
  }
  p->SetDpProperty( FPM::Dp::cfgUCPTpollRate, 500 );
  return (Variable<T>*) (*CUFPTSC1::GetSingleton()->m_pDeclaredVariables->find( pszName )).second;
}

} // namespace _9FFD030000000000_5__UFPTSC1_DRV

#endif // _FPM_UFPTSC1_H
